﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using System.Net;
using System.Security;
using System.Security.Principal;
using System.Text;
using System.Web.Configuration;
using System.Web.Security;
using Microsoft.AccessControl.ASPNET;
using Microsoft.AccessControl.SDK.ACSCalculator.AuthorizationManager;
using Microsoft.AccessControl.SDK.GettingStarted.Service;


public sealed class AuthorizationUtil 
{
    const string serviceNamespace = "updateToServiceNamespace";
    const string signingKey = "updateToTokenPolicyKey";

    const string acsHostName = "accesscontrol.windows.net";

    const string trustedAudience = "http://localhost/ASPNETUrlAuthorization";

    private static bool SetUnauthorized()
    {
        HttpContext.Current.Response.StatusCode = (int)HttpStatusCode.Unauthorized;
        HttpContext.Current.Response.End();
        return false;
    }

    public static void AuthenticateRequest()
    {
        bool isAuthorized = false;

        // store the context locally
        HttpContext context = HttpContext.Current;

        // get the authorization information for the requested URI
        string url = context.Request.Url.LocalPath;
        AuthorizationManager authMgr = AuthorizationManager.CreateAuthorizationManager(url);

        // Check to see if we need authentication
        if (authMgr.RequiresAuthorization)
        {
            // Look for the authorization header
            string authHeader = context.Request.Headers["Authorization"];

            // check that the authorization header is present
            if (!string.IsNullOrEmpty(authHeader))
            {
                // check that it starts with 'WRAPv0.8'
                if (!authHeader.StartsWith("WRAPv0.8 ", StringComparison.OrdinalIgnoreCase))
                {
                    isAuthorized = SetUnauthorized();
                }

                Microsoft.AccessControl.ASPNET.TokenValidator validator =
                    new Microsoft.AccessControl.ASPNET.TokenValidator(
                    acsHostName,
                    serviceNamespace,
                    trustedAudience,
                    signingKey);

                string[] headerParts = authHeader.Split(new string[] { "WRAPv0.8 " }, StringSplitOptions.None);

                // validate the header
                if (!validator.Validate(headerParts[1]))
                {
                    isAuthorized = SetUnauthorized();
                }

                // create the user
                context.User = new ServiceUser(headerParts[1], validator);

                // check if the user is authorized based on config settings
                if (authMgr.VerifyAuthorization(context.User))
                {
                    isAuthorized = true;
                }
                else
                {
                    isAuthorized = SetUnauthorized();
                }
            }
        }

        // Check for authentication and return HTTP 401 if none
        if (!isAuthorized)
        {
            // Assign the status code
            context.Response.StatusCode = (int)HttpStatusCode.Unauthorized;

            // Calculate the realm
            string realm = string.Format("ACSrealm=\"{0}\"", context.Request.Url.GetLeftPart(UriPartial.Path));

            // Add the authentication header
            context.Response.AddHeader("WWW-Authenticate", realm);

            // End the request
            context.Response.End();
        }
    }

   
}
